package com.bxm.localnews.activity.common.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties("activity.sign")
@Data
public class SignProperties {

    /**
     * 签到排行榜的数量
     */
    private Integer rankSize;

    /**
     * 开通签到排行榜的要求数量
     */
    private Integer openDemandSize;

    /**
     * 开通签到排行榜的最低签到天数要求
     */
    private Integer openMinRequirement;


    /**
     * 签到新人时间比较值  3.8.0需求（默认为上线时间，该时间后的用户则为新用户）
     * 比如：
     * 2020-11-01 12:00:00
     */
    private String signTimeFlag = "2020-10-27 12:00:00";


    /**
     * ver 3.8.0  新人用户连续签到礼包
     */
    private String giftPackage="[{ \"signDay\": 7, \"giftType\": 1, \"reward\": \"20-100\" }]";

}
