package com.bxm.localnews.activity.common.constant;

import java.util.Arrays;

/**
 * Created by Arei on 2018/10/20.
 */
public enum PrivilegeStatusEnum {
    //进行中
    PROCESSING(3),
    //等待开始
    WAIT_TO_START(2),
    //结束
    END(1),
    //取消
    CANCEL(0);
    private Integer status;

    PrivilegeStatusEnum(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return status;
    }

    public static PrivilegeStatusEnum getEnumByStatus(Integer status) {
        return Arrays.asList(PrivilegeStatusEnum.values()).stream().filter(
                privilegeStatusEnum -> status.equals(privilegeStatusEnum.getStatus())
        ).findAny().orElse(null);
    }
}
