package com.bxm.localnews.activity.common.constant;

/**
 * <p>
 *     红包客户端显示状态
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/18
 */
public enum RedPacketDisplayStatesEnum {
    UNDER_AUDIT(0,"审核中"),
    REJECTED(1,"审核不通过"),
    PASS_AUDIT(2,"审核通过"),
    BROUGHT_OUT(3,"已被领完"),
    ;

    private int code;
    private String value;

    RedPacketDisplayStatesEnum(int code, String value){
        this.code = code;
        this.value = value;
    }

    public static String getValue(int code){
        for (RedPacketDisplayStatesEnum statusEnum : RedPacketDisplayStatesEnum.values()){
            if(code == statusEnum.code){
                return statusEnum.value;
            }
        }
        return "";
    }
    public int getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }
}
