package com.bxm.localnews.activity.common.utils;

import com.bxm.newidea.component.tools.DateUtils;

import java.text.ParseException;
import java.util.Date;

/**
 * <p></p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/18
 */
public class DateUtil {
    private static final String JUST_NOW = "刚刚";
    private static final String MINUTE_AGO = "分钟前";
    private static final String HOUR_AGO = "小时前";
    private static final String DAY_AGO = "天前";

    /**
     * 获取时间的中文描述
     *      T<5分钟，显示为：刚刚
     *      5分钟<=T<1小时，显示为：x分钟前，x取整，舍弃秒位数值
     *      1小时<=T<24小时，显示为：x小时前，同上
     *      T>=24小时，显示为：x天前，同上
     * @date: 2019/4/18
     * @param date
     * @return java.lang.String
     * @throws 
     */
    public static String getDateLog(Date date){
        if (null == date) {
            return null;
        }
        //获取时间差
        long delta = System.currentTimeMillis() - date.getTime();

        if (delta < DateUtils.MINUTE_MILLISECOND * 5) { // 5分钟
            return JUST_NOW;
        }
        if (delta < DateUtils.HOUR_MILLISECOND) {
            long minutes = delta / DateUtils.MINUTE_MILLISECOND;
            return (minutes <= 0 ? 1 : minutes) + MINUTE_AGO;
        }
        if (delta < DateUtils.DAY_MILLISECOND) {
            long hours = delta / DateUtils.HOUR_MILLISECOND;
            return (hours <= 0 ? 1 : hours) + HOUR_AGO;
        } else {
            long days = delta / DateUtils.DAY_MILLISECOND;
            return (days <= 0 ? 1 : days) + DAY_AGO;
        }
    }

    /**
     * 时间格式转换
     * @date: 2019/4/18
     * @param date
     * @param pattern
     * @return java.util.Date
     * @throws 
     */
    public static Date parseDate(String date,String pattern){
        try {
            return org.apache.commons.lang.time.DateUtils.parseDate(date, new String[] { pattern });
        } catch (ParseException e) {
            return null;
        }
    }

    public static void main(String[] args) {
//        Date date = parseDate("2019-04-16 17:46:00","yyyy-MM-dd HH:mm:ss");
//        System.out.println(getDateLog(date));
    }
}
