package com.bxm.localnews.activity.common.utils;

import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.MultimediaInfo;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.text.DecimalFormat;
import java.util.Stack;

/**
 * 录音文件工具类
 * @author liujia
 */
@Slf4j
public class RecordUtils {
    static String[] units = {"", "十", "百", "千", "万", "十万", "百万", "千万", "亿", "十亿", "百亿", "千亿", "万亿"};

    static char[] numArray = {'零', '一', '二', '三', '四', '五', '六', '七', '八', '九'};

    private static String[] number_zh = new String[]{"零", "一", "二", "三", "四", "五", "六", "七", "八", "九", "十"};

    private RecordUtils() {

    }

    /**
     * 获取录音文件时长
     * @param recordFile 录音文件
     * @return 录音文件时长（时长：秒）
     */
    public static int getDuration(File recordFile) {
        Encoder encoder = new Encoder();
        long ls = 0;
        MultimediaInfo m;
        try {
            m = encoder.getInfo(recordFile);
            ls = m.getDuration() / 1000;

        } catch (Exception e) {
            log.error("获取录音时长错误，文件为：" + recordFile, e);
        }
        return (int) ls;
    }

    public static String shuzizhuanzhongwen(Long number) {
        StringBuffer sb = new StringBuffer();

        String str = number.toString();
        Stack<String> strStack = new Stack<>();
        for (int i = 0; i < str.length(); i++) {
            // 带 拾、佰、仟...  修改为  (int) (number % 10) + getUnitZH(Long.valueOf(i))
            strStack.push(number_zh[(int) (number % 10)]);
            number = number / 10;
        }
        while (!strStack.isEmpty()) {
            sb.append(strStack.pop());
        }
        return sb.toString();
    }

    /**
     * 将整数转换成汉字数字
     * @param num
     * @return
     */
    public static String formatInteger(long num) {
        char[] val = String.valueOf(num).toCharArray();
        int len = val.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; i++) {
            String m = val[i] + "";
            int n = Integer.valueOf(m);
            boolean isZero = n == 0;
            String unit = units[(len - 1) - i];

            if (isZero && '0' != val[i - 1]) {
                sb.append(numArray[n]);
            } else {
                sb.append(numArray[n]);
                sb.append(unit);
            }
        }
        return sb.toString();
    }

//    private static ThreadLocal<DecimalFormat> NUMBER_FORMAT_LOCAL = new ThreadLocal<DecimalFormat>() {
//        @Override
//        public DecimalFormat get() {
//            return new DecimalFormat("#0.00");
//        }
//    };

    /**
     * 将小数转换成汉字数字
     * 超过10万的转换有问题
     * @param decimal
     * @return
     */
    public static String formatDecimal(long decimal) {

        if (decimal > 99999) {
            return shuzizhuanzhongwen(decimal);
        }

        return tansform(decimal);
    }

    private static String tansform(long number) {

        String a = String.valueOf(number);
        int length = a.length();

        String digit = "";
        String num = "";
        String zh = "";
        //“零”的间隔输出
        boolean zerointerval = true;
        //int comma=0;//控制逗号输出;
        for (int i = 0; i < a.length(); i++) {
            if (length == 2) {
                digit = "十";

            } else if (length == 3) {
                digit = "百";
            } else if (length == 4) {
                digit = "千";
            } else if (length == 5) {
                digit = "万";
            } else if (length == 6) {
                digit = "十万";
            } else if (length == 7) {
                digit = "百万";
            } else if (length == 8) {
                digit = "千万";
            } else if (length == 9) {
                digit = "亿";
            } else if (length == 10) {
                digit = "十亿";
            } else if (length == 11) {
                digit = "百亿";
            } else if (length == 12) {
                digit = "千亿";
            } else if (length == 13) {
                digit = "万亿";
            } else if (length == 1) {
                digit = "";
            }

            String s = (String) (a.subSequence(i, i + 1));


            if ("1".equals(s)) {
                num = "一";
            } else if ("2".equals(s)) {
                num = "二";
            } else if ("3".equals(s)) {
                num = "三";
            } else if ("4".equals(s)) {
                num = "四";
            } else if ("5".equals(s)) {
                num = "五";
            } else if ("6".equals(s)) {
                num = "六";
            } else if ("7".equals(s)) {
                num = "七";
            } else if ("8".equals(s)) {
                num = "八";
            } else if ("9".equals(s)) {
                num = "九";
            } else if ("0".equals(s)) {
                //如果可以输出“零”
                if (zerointerval) {
                    num = "零";
                    digit = "";
                    //当输出第一个零后，后面的数为0也不会输出零，如1003不是一千零零三
                    zerointerval = false;
                } else {
                    num = "";
                    digit = "";
                }
            }

            length--;
            if (!"".equals(digit)) {
                //当输出其他数字后，零又再可以被输出
                zerointerval = true;
            }


            //拼接中文,防止输出更多的亿和万
            if (digit.contains("亿")) {

                zh = zh.replace("亿", "");
            }
            if (digit.contains("万")) {

                zh = zh.replace("万亿", "wanyi");
                zh = zh.replace("万", "");
                zh = zh.replace("wanyi", "万亿");
            }

            zh = zh + num + digit;

        }


        zh = deletezero(zh);
        return zh;


    }

    /**
     * 如果最后一位数字是零，则删掉
     */
    public static String deletezero(String zh) {

        String lasts = (String) (zh.subSequence(zh.length() - 1, zh.length()));

        if ("零".equals(lasts)) {
            zh = zh.substring(0, zh.length() - 1);
        }

        return zh;
    }
}
