package com.bxm.localnews.activity.common.utils;

import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Decoder;

import javax.annotation.Resource;
import java.util.Date;
import java.util.UUID;

/**
 * 上传base64图片
 */
@Component
public class UploadBase64Img {
    private static final String BASE64_JPEG = "data:image/jpeg;base64,";
    private static final String BASE64_PNG = "data:image/png;base64,";

    @Resource
    private AliyunOSSService aliyunOSSService;

    public String uploadBase64Img(String base64Str) {
        if (StringUtils.isBlank(base64Str)) {// 图像数据为空
            return null;
        }

        String fileName = UUID.randomUUID().toString();
        if (base64Str.contains(BASE64_JPEG)) {
            base64Str = base64Str.replace(BASE64_JPEG, "");
            if (StringUtils.isBlank(base64Str)) {
                return null;
            }
            fileName += ".jpeg";
        } else if (base64Str.contains(BASE64_PNG)) {
            base64Str = base64Str.replace(BASE64_PNG, "");
            if (StringUtils.isBlank(base64Str)) {
                return null;
            }
            fileName += ".png";
        }

        byte[] bytes = generateImage(base64Str);
        if (null != bytes) {
            return aliyunOSSService.upload(bytes, generateDirByFileName(fileName));
        }

        return null;
    }

    private byte[] generateImage(String imgStr) {
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            // Base64解码
            byte[] bytes = decoder.decodeBuffer(imgStr);
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] < 0) {// 调整异常数据
                    bytes[i] += 256;
                }
            }

            return bytes;
        } catch (Exception e) {
            return null;
        }
    }

    private String generateDirByFileName(String fileName) {
        String suffix = this.generateSuffix(fileName);
        String todayStr = DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date());
        return (new StringBuilder()).append(suffix).append("/").append(todayStr).append("/").append(fileName).toString();
    }

    private String generateSuffix(String fileName) {
        String suffix = FileUtils.getFilextension(fileName);
        String contentType = FileTypeEnum.getContentType(suffix);
        if (StringUtils.isBlank(contentType)) {
            suffix = "txt";
        }

        return suffix;
    }
}

























