package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.vo.WechatUserInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Mapper
public interface LotteryDrawMapper {

    String getCodeByLocation(@Param("area") String area);

    BigDecimal getWalletCash(@Param("userId") Long userId);

    Integer getRemainTimes(@Param("userId") Long userId);

    List<Map<String, Object>> getPrizeList();

    List<WechatUserInfoVo> getWinUserList();

    Integer getHasDrawTimes(@Param("userId") Long userId);

    Boolean updateDrawTimes(@Param("userId") Long userId);

    Boolean addRemainTimes(@Param("userId") Long userId, @Param("totalTimes") Integer totalTimes);

    List<WechatUserInfoVo> getDetailList(@Param("userId") Long userId);

    Boolean disableUserRedPacket(@Param("userId") Long userId);

    Long getInviteUserByUserId(@Param("userId") Long userId);
}