package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.vo.NoviceTaskRecord;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface NoviceTaskRecordMapper {
    /**
     * 删除新手任务记录
     *
     * @param id
     * @return
     */
    int deleteByPrimaryKey(Long id);

    /**
     * 插入新手任务记录
     *
     * @param record 新手任务
     * @return
     */
    int insert(NoviceTaskRecord record);

    /**
     * 插入新手任务记录
     *
     * @param record 新手任务
     * @return
     */
    int insertSelective(NoviceTaskRecord record);

    /**
     * 查询新手任务记录
     *
     * @param id 新手任务记录id
     * @return
     */
    NoviceTaskRecord selectByPrimaryKey(Long id);

    /**
     * 更新新手活动记录
     *
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(NoviceTaskRecord record);

    /**
     * 更新新手活动记录
     *
     * @param record
     * @return
     */
    int updateByPrimaryKey(NoviceTaskRecord record);

    /**
     * 根据任务Id和userId 查询新手任务
     *
     * @param taskId daily_task表的任务Id
     * @param userId 用户id
     * @return
     */
    NoviceTaskRecord findSelectiveByType(@Param("taskId") Long taskId, @Param("userId") Long userId);

    /**
     * 批量添加用户新手任务
     *
     * @param recordList 需要初始化的新手任务列表
     */
    void batchAdd(@Param("recordList") List<NoviceTaskRecord> recordList);
    
    /**
     * 根据任务Id和userId 查询新手任务
     *
     * @param name
     * @param userId
     * @return
     */
    NoviceTaskRecord findSelectiveByTaskName(@Param("name") String name, @Param("userId") Long userId);
}