package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.vo.SignRecord;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface SignRecordMapper {

    int insertSelective(SignRecord record);

    List<SignRecord> listUserSignRecord(Long userId);

    /**
     * 统计签到天数
     * @param userId 用户ID
     * @return 签到总天数
     */
    int countSignToday(Long userId);

    /**
     * 获取用户的最后一条签到记录
     * @param userId 用户ID
     * @return 签到记录
     */
    SignRecord getLastSignRecord(Long userId);

}