package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.param.RecordWechatParam;
import com.bxm.localnews.activity.param.VipViewRecordParam;
import com.bxm.localnews.activity.vo.VipViewRecord;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author zhaoyadong 2018/12/24 17:51
 * @desc
 */
@Mapper
public interface VipViewRecordMapper {

    /**
     * 更新用户和好友的绑定关系
     * @return
     */
    int updateByPrimaryKey(VipViewRecord vipViewRecord);

    /**
     * 查看用户邀请信息（包括成功邀请和查看用户vip信息页面的数据）
     * @param vipViewRecordParam
     * @return
     */
    List<VipViewRecord> selectVipRecordList(VipViewRecordParam vipViewRecordParam);

    /**
     * 领取vip
     * @param record
     * @return
     */
    int insertSelective(VipViewRecord record);

    /**
     * 获取微信用户最后一次查看用户vip分享页面的记录
     * @param wechatUid
     * @return
     */
    VipViewRecord getLastVipViewRecord(@Param("wechatUid") String wechatUid);

    /**
     * 获取微信用户已帮助用户激活vip
     * @param wechatUid
     * @return
     */
    VipViewRecord getCheckedByWechatUid(@Param("wechatUid") String wechatUid);

    /**
     * 查询微信好友是否已查看用户分享vip页面
     * @param recordWechatParam
     * @return
     */
    VipViewRecord getViewRecordByUserAndWechatUid(RecordWechatParam recordWechatParam);

    /**
     * 更新用户查看的信息
     * @param wechatUid
     * @return
     */
    int updateViewRecordByUser(@Param("wechatUid") String wechatUid);
}
