package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.vo.CommodityVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Created by Arei on 2018/10/19.
 */
@Mapper
public interface CommodityMapper {

    /**
     * 根据性质查询商品(如:普通商品还是促销商品)
     * @param category
     * @return
     */
    List<CommodityVO> selectByCategory(Byte category);

    /**
     * 根据用户和商品id查询用户是否拥有这个商品
     * @param userId
     * @return
     */
    Integer countVipMovie(@Param("userId") Long userId);

    /**
     * 更新商品库存
     * @param id
     */
    void updateCommodityNum(@Param("id") Long id);
}
