package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.dto.PrivilegeDTO;
import com.bxm.localnews.activity.dto.PrivilegeListDTO;
import com.bxm.localnews.activity.param.PrivilegeOverviewParam;
import com.bxm.localnews.activity.param.PrivilegeParam;
import com.bxm.localnews.activity.param.PrivilegeRecommendParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Created by Arei on 2018/10/19.
 */
@Mapper
public interface PrivilegeMapper {
    /**
     * 获取活动列表
     *
     * @param privilegeParam
     * @return
     */
    List<PrivilegeListDTO> listPrivilege(PrivilegeParam privilegeParam);

    /**
     * 获取活动列表[all]
     *
     * @param privilegeParam
     * @return
     */
    List<PrivilegeListDTO> listAllPrivilege(PrivilegeOverviewParam privilegeParam);

    /**
     * 获取推荐活动列表
     *
     * @param privilegeRecommendParam
     * @return
     */
    List<PrivilegeListDTO> listRecommendPrivilege(PrivilegeRecommendParam privilegeRecommendParam);

    /**
     * 获取活动详情
     *
     * @param privilegeId
     * @return
     */
    PrivilegeDTO getPrivilegeDetail(@Param("privilegeId") Long privilegeId);

    /**
     * 更新活动参加人数
     *
     * @param privilegeId
     * @return
     */
    int updatePrivilegeParticipantNum(@Param("privilegeId") Long privilegeId);
}
