package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.vo.CommodityCode;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface CommodityCodeMapper {

    int deleteByPrimaryKey(Long id);

    int insert(CommodityCode record);

    int insertSelective(CommodityCode record);

    CommodityCode selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(CommodityCode record);

    int updateByPrimaryKey(CommodityCode record);

    /**
     * 获取num个未使用的商品信息
     *
     * @param commodityId 商品ID
     * @param num         获取商品数量
     * @return 商品编码信息列表
     */
    List<CommodityCode> getUnusedCommodities(@Param("commodityId") long commodityId, @Param("num") int num);

    List<CommodityCode> getUseCommoditiesAndPrivilege(@Param("commodityId") long commodityId, @Param("num") int num,
                                                          @Param("privilegeId") long privilegeId);

    /**
     * 获取商品下已使用的编码
     *
     * @param commodityId 商品ID
     * @return 商品下已使用的商品编码列表
     */
    List<CommodityCode> getUsedCodes(long commodityId);

    /**
     * 活动开奖时，将活动中奖人对应的编码设置为已使用状态
     *
     * @param code 商品编号
     * @param commodityId 商品ID
     * @return 操作结果
     */
    int updateToUsed(@Param("code") String code, @Param("commodityId") long commodityId);

    /**
     * 根据商品删除商品编码
     *
     * @param commdotityId 商品ID
     * @return 删除数量
     */
    int deleteByCommodityId(long commdotityId);

}