package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.param.CashDetailParam;
import com.bxm.localnews.activity.vo.WechatUserInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Mapper
@Repository
public interface LotteryDrawMapper {

    String getCodeByName(@Param("name") String name);

    BigDecimal getWalletCash(@Param("userId") Long userId);

    Integer getRemainTimes(@Param("userId") Long userId);

    List<Map<String, Object>> getPrizeList();

    List<WechatUserInfoVo> getWinUserList();

    Integer getHasDrawTimes(@Param("userId") Long userId);

    int updateDrawTimes(@Param("userId") Long userId);

    int addRemainTimes(@Param("userId") Long userId, @Param("totalTimes") Integer totalTimes);

    List<WechatUserInfoVo> getDetailList(CashDetailParam param);

    int disableUserRedPacket(@Param("userId") Long userId);

    Long getInviteUserByUserId(@Param("userId") Long userId);
}