package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.dto.RedPacketObtainDOT;
import com.bxm.localnews.activity.dto.RedPacketUpdateDTO;
import com.bxm.localnews.activity.param.WallRedPacketParam;
import com.bxm.localnews.activity.vo.RedPacket;
import com.bxm.localnews.activity.vo.RedPacketVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 红包信息表 Mapper 接口
 * </p>
 *
 * @author JandMin
 * @since 2019-04-18
 */
@Repository
@Mapper
public interface RedPacketMapper {

    RedPacket queryOne(Long id);

    /**
     * 查询 该区域可领取的红包id
     * 条件：在线的、可领取的红包墙红包
     * @param areaCode
     * @return
     */
    HashSet<Long> queryByAreaCode(String areaCode);

    /**
     * 分页查询当前区域 在线的、可领取或者已领取的红包墙红包
     * @param wallRedPacketParam
     * @return
     */
    List<RedPacketVo> queryWallByPageSize(WallRedPacketParam wallRedPacketParam);

    /**
     * 查询6个当前区域已领完的红包
     * @param areaCode
     * @return
     */
    List<RedPacketVo> getObtainedAll(String areaCode);

    /**
     * 获取用户发过的所有红包汇总金额
     * @date: 2019/4/18
     * @param userId
     * @return java.util.List<java.util.Map<java.lang.String,java.lang.Object>>
     * @throws 
     */
    Map<String,Object> getTotalSentRedPacket(@Param("userId")Long userId);

    /**
     * 获取用户发送红包记录列表
     * @date: 2019/4/18
     * @param userId
     * @return java.util.List<com.bxm.localnews.activity.vo.RedPacket>
     * @throws 
     */
    List<RedPacket> listRedPacketByUser(@Param("userId")Long userId);

    /**
     * 新增红包
     * @date: 2019/4/19
     * @param redPacket
     * @return java.lang.Integer
     * @throws
     */
    Integer insert(RedPacket redPacket);

    /**
     * 用户修改红包信息
     * @date: 2019/4/19
     * @param redPacket
     * @return java.lang.Integer
     * @throws
     */
    Integer update(RedPacket redPacket);

    /**
     * 根据用户id和红包id获取红包信息用于修改
     * @date: 2019/4/19
     * @param rpId
     * @param userId
     * @return com.bxm.localnews.activity.dto.RedPacketUpdateDTO
     * @throws
     */
    RedPacket selectRedPacketByIdAndUserId(@Param("rpId")Long rpId,@Param("userId")Long userId);


    /**
     * 减扣红包剩余金额
     * @param redPacketObtainVo
     * @return
     */
    Integer subtractSurplusAmount(RedPacketObtainDOT redPacketObtainVo);

    /**
     * 修改红包支付状态
     * @date: 2019/4/25
     * @param redPacket
     * @return java.lang.Integer
     * @throws
     */
    Integer updatePayStatus(RedPacket redPacket);
}
