package com.bxm.localnews.activity.domain;

import com.bxm.localnews.activity.param.ObtainHistoryParam;
import com.bxm.localnews.activity.vo.RedPacketObtainHistory;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <p>
 * 红包获取记录 Mapper 接口
 * </p>
 *
 * @author JandMin
 * @since 2019-04-18
 */
@Repository
@Mapper
public interface RedPacketObtainHistoryMapper {

    /**
     * 查询在 rpIds 红包列表中，哪些红包被该 userId 用户领取过
     *
     * @param userId 用户id
     * @param rpIds  红包id列表
     * @return
     */
    HashSet<Long> queryRpIdsWhichUserGet(@Param(value = "userId") Long userId, @Param(value = "rpIds") Set<Long> rpIds);

    /**
     * 通过红包id和用户id查询记录
     * @param userId
     * @param rpId
     * @return
     */
    RedPacketObtainHistory queryByUserAndRp(@Param(value = "userId") Long userId, @Param(value = "rpId") Long rpId);

    /**
     * 查询用户是否领取过该红包
     * @param userId
     * @param rpId
     * @return
     */
    Integer countByUserAndRp(@Param(value = "userId") Long userId, @Param(value = "rpId") Long rpId);

    /**
     * 分页查询最近领取历史记录 按领取时间倒序
     * @param obtainHistoryParam
     * @return
     */
    List<RedPacketObtainHistory> queryByPageSize(ObtainHistoryParam obtainHistoryParam);

    /**
     * 查询评分前20名
     * @param rpId
     * @return
     */
    List<RedPacketObtainHistory> queryScoreList(Long rpId);

    /*
     * 获取用户获取他人红包的总金额
     * @date: 2019/4/18
     * @param userId
     * @return java.util.List<java.util.Map<java.lang.String,java.lang.Object>>
     * @throws 
     */
    Map<String,Object> getTotalGottenRedPacket(@Param("userId")Long userId);

    /**
     * 获取用户领取红包记录列表
     * @date: 2019/4/18
     * @param userId
     * @return java.util.List<com.bxm.localnews.activity.vo.RedPacketObtainHistory>
     * @throws 
     */
    List<RedPacketObtainHistory> listRedPacketByUser(Long userId);


    /**
     * 添加一条记录
     * @param redPacketObtainHistory
     * @return
     */
    Integer addOne(RedPacketObtainHistory redPacketObtainHistory);
}
