package com.bxm.localnews.activity.domain;

import java.util.List;

import com.bxm.localnews.activity.vo.SignRecord;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface SignRecordMapper {

    int insertSelective(SignRecord record);

    int updateTodaySign(@Param("userId") Long userId, @Param("signDate") String signDate, @Param("signDay") Integer signDay);

    List<SignRecord> listUserSignRecord(Long userId);

    /**
     * 统计签到天数
     *
     * @param userId 用户ID
     * @return 签到总天数
     */
    int countSignToday(Long userId);

    /**
     * 获取用户的最后一条签到记录
     *
     * @param userId 用户ID
     * @return 签到记录
     */
    SignRecord getLastSignRecord(Long userId);

    /**
     * 获取用户今天的签到记录
     *
     * @param userId
     * @return
     */
    SignRecord getTodaySignRecord(Long userId);

    /**
     * 获取用户昨天的签到记录
     *
     * @param userId
     * @return
     */
    SignRecord getYesterdaySignRecord(Long userId);

    /**
     * 获取用户前天的签到信息
     *
     * @param userId
     * @return
     */
    SignRecord getBeforeYesterDaySignRecord(Long userId);

    /**
     * 根据月份获取用户对应的签到列表
     *
     * @param userId
     * @return
     */
    List<SignRecord> getMonthSignRecord(@Param("userId") Long userId, @Param("signDate") String signDate);

    List<SignRecord> listSignRecordByUser(@Param("tableName") String tableName);
}