package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(description = "发帖排行榜用户信息")
public class ForumRankUserDTO extends BaseRankTopUserDTO {
    @ApiModelProperty("true表示当前用户已关注该用户")
    private Boolean follow;

    @ApiModelProperty("获得的点赞数")
    private Integer likeTotal;

    @ApiModelProperty("内容质量得分（热度值）")
    private Integer contentQualityScore;

    @ApiModelProperty("用户最近的发帖（暂定两条）")
    private List<ForumPostDTO> postList;
}
