package com.bxm.localnews.activity.dto;

import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2020/5/4 14:51
 */
@ApiModel(description = "特惠商家列表信息")
@Data
@Builder
public class MerchantListDTO extends BaseBean {

    @ApiModelProperty("商家id")
    private Integer merchantId;

    @ApiModelProperty("商户名")
    private String merchantName;

    @ApiModelProperty("商家头像")
    private String headImg;

    @ApiModelProperty("门面图片（多张使用逗号分隔）")
    private List<String> facadeUrl = new ArrayList<>();

    @ApiModelProperty("用户和商家之间的距离")
    private String distance;

    @ApiModelProperty("距离")
    @JsonIgnore
    private Long distanceNum;

    @ApiModelProperty("置顶开始时间")
    @JsonIgnore
    private Date sortStartTime;

    @ApiModelProperty("置顶结束时间")
    @JsonIgnore
    private Date sortEndTime;

    @ApiModelProperty("商家简述")
    private String shortDesc;

    @ApiModelProperty("商家折扣")
    private BigDecimal discount;

    @ApiModelProperty("商家所在街道名")
    private String townName;

    @ApiModelProperty("经度")
    private Double geoLat;

    @ApiModelProperty("维度")
    private Double geoLng;

    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("是否开通VIP 0：否  1：是")
    private Integer isVip;

    @ApiModelProperty("商家类型描述")
    private String merchantTypeDesc;

    @Tolerate
    public MerchantListDTO() {
    }
}
