package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

@ApiModel(description = "新闻相关任务完成后的奖励信息")
public class NewsMissionRewardDto {

    @ApiModelProperty("获得金币数")
    private Long goldNum;

    @ApiModelProperty("用户总金币数")
    private BigDecimal totalGold;

    @ApiModelProperty("任务名称")
    private String taskName;

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Long getGoldNum() {
        return goldNum;
    }

    public void setGoldNum(Long goldNum) {
        this.goldNum = goldNum;
    }

    public BigDecimal getTotalGold() {
        return totalGold;
    }

    public void setTotalGold(BigDecimal totalGold) {
        this.totalGold = totalGold;
    }

    public static NewsMissionRewardDto buildDefaultRewardDto(){
        NewsMissionRewardDto newsMissionRewardDto = new NewsMissionRewardDto();
        newsMissionRewardDto.setGoldNum(0L);
        return newsMissionRewardDto;
    }
}
