package com.bxm.localnews.activity.dto;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName PacketHistoryDTO
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/17 21:32
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/17 21:32
 **/
@ApiModel(description = "红包领取记录")
@Data
public class PacketHistoryDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("头像")
    private String userImg;
    @ApiModelProperty("昵称")
    private String userName;
    @ApiModelProperty("领取红包时间")
    private Long obtainTime;
    @ApiModelProperty("录音长度")
    private Integer recordLength;
    @ApiModelProperty("评分")
    private Integer score;
    @ApiModelProperty("领取红包金额")
    private String obtainAmount;
    @ApiModelProperty("口令地址")
    private String recordUrl;
}
