package com.bxm.localnews.activity.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * Created by Arei on 2018/10/17.
 */
@ApiModel(description = "优惠活动详情")
public class PrivilegeDTO extends BasePrivilegeDTO {

    @ApiModelProperty(value = "活动海报图地址")
    private String imgUrl;

    @ApiModelProperty(value = "活动截止时间(非开始时间)", hidden = true)
    private Date endTime;

    @ApiModelProperty(value = "参与人数", hidden = true)
    @JsonIgnore
    private Long participantCount;

    @ApiModelProperty(value = "排行榜列表", hidden = true)
    @JsonIgnore
    private List<LeaderboardDTO> leaderboardDTOS;

    @ApiModelProperty("商户名")
    private String merchantName;

    @ApiModelProperty("门面图片（多张使用逗号分隔）")
    private String facadeUrl;

    @ApiModelProperty("商户展示地址")
    private String displayAddress;

    @ApiModelProperty("活动详情，图文混排，支持富文本")
    private String content;

    @ApiModelProperty("活动详情页短链")
    private String shortLink;

    @ApiModelProperty(value = "倒计时，剩余开始时间的毫秒数", hidden = true)
    private Long countdown;

    @ApiModelProperty(value = "中奖人列表，活动结束后（status=1）有值", hidden = true)
    private List<WinnerDTO> winnerDTOS;

    @ApiModelProperty("分享背景图地址")
    private String shareBgUrl;

    @ApiModelProperty(value = "活动开始时间", hidden = true)
    private Date startTime;

    @JsonIgnore
    private List<String> areaCodeList;

    @JsonIgnore
    private Long id;

    @ApiModelProperty(value = "是否已经参与", hidden = true)
    @JsonIgnore
    private Boolean participated;

    @ApiModelProperty(value = "是否已经助力过邀请人", hidden = true)
    @JsonIgnore
    private Boolean help;

    @JsonIgnore
    private Boolean globalFlag;

    @ApiModelProperty(value = "奖品（商品）类型，1电影票/2其他", hidden = true)
    @JsonIgnore
    private Integer drawSign;

    @JsonIgnore
    private String commodityType;

    @ApiModelProperty("商家介绍，图文混排，支持富文本")
    private String description;

    @ApiModelProperty("活动引导语")
    private String guidance;

    @ApiModelProperty(value = "活动的微信群二维码", hidden = true)
    private String barcode;

    @ApiModelProperty(value = "带GIF图的活动的微信群二维码", hidden = true)
    private String barcodeGif;

    @ApiModelProperty("商家纬度")
    private Double geoLat;

    @ApiModelProperty("商家经度")
    private Double geoLng;

    @ApiModelProperty("距离")
    private String distance;

    @ApiModelProperty("商家客服电话")
    private String servicePhone;

    @ApiModelProperty("商家头像")
    private String headImg;

    @ApiModelProperty(value = "包含二维码的活动海报图链接", hidden = true)
    private String codeUrl;

    @ApiModelProperty(value = "折扣")
    private String discount;

    @ApiModelProperty(value = "商圈")
    private String businessArea;

    @ApiModelProperty(value = "营业开始时间")
    private String businessStartTime;

    @ApiModelProperty(value = "营业结束时间")
    private String businessEndTime;

    @ApiModelProperty(value = "免费享商品标题")
    private String freeTitle;

    @ApiModelProperty(value = "免费享条件")
    private String freeDetail;

    public String getFreeTitle() {
        return freeTitle;
    }

    public void setFreeTitle(String freeTitle) {
        this.freeTitle = freeTitle;
    }

    public String getFreeDetail() {
        return freeDetail;
    }

    public void setFreeDetail(String freeDetail) {
        this.freeDetail = freeDetail;
    }

    public String getBusinessArea() {
        return businessArea;
    }

    public void setBusinessArea(String businessArea) {
        this.businessArea = businessArea;
    }

    public String getBusinessStartTime() {
        return businessStartTime;
    }

    public void setBusinessStartTime(String businessStartTime) {
        this.businessStartTime = businessStartTime;
    }

    public String getBusinessEndTime() {
        return businessEndTime;
    }

    public void setBusinessEndTime(String businessEndTime) {
        this.businessEndTime = businessEndTime;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }


    public String getCodeUrl() {
        return codeUrl;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }

    public String getHeadImg() {
        return headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public String getServicePhone() {
        return servicePhone;
    }

    public void setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
    }

    public Double getGeoLat() {
        return geoLat;
    }

    public void setGeoLat(Double geoLat) {
        this.geoLat = geoLat;
    }

    public Double getGeoLng() {
        return geoLng;
    }

    public void setGeoLng(Double geoLng) {
        this.geoLng = geoLng;
    }

    public String getGuidance() {
        return guidance;
    }

    public void setGuidance(String guidance) {
        this.guidance = guidance;
    }

    public String getBarcode() {
        return barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getBarcodeGif() {
        return barcodeGif;
    }

    public void setBarcodeGif(String barcodeGif) {
        this.barcodeGif = barcodeGif;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCommodityType() {
        return commodityType;
    }

    public void setCommodityType(String commodityType) {
        this.commodityType = commodityType;
    }

    public Integer getDrawSign() {
        if ("电影".equals(this.commodityType)) {
            return 1;
        } else {
            return 2;
        }
    }

    public void setDrawSign(Integer drawSign) {
        this.drawSign = drawSign;
    }

    public Boolean getHelp() {
        return help;
    }

    public void setHelp(Boolean help) {
        this.help = help;
    }

    public Boolean getGlobalFlag() {
        return globalFlag;
    }

    public void setGlobalFlag(Boolean globalFlag) {
        this.globalFlag = globalFlag;
    }

    public Boolean getParticipated() {
        return participated;
    }

    public void setParticipated(Boolean participated) {
        this.participated = participated;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public List<String> getAreaCodeList() {
        return areaCodeList;
    }

    public void setAreaCodeList(List<String> areaCodeList) {
        this.areaCodeList = areaCodeList;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public List<WinnerDTO> getWinnerDTOS() {
        return winnerDTOS;
    }

    public void setWinnerDTOS(List<WinnerDTO> winnerDTOS) {
        this.winnerDTOS = winnerDTOS;
    }

    public Long getCountdown() {
        return countdown;
    }

    public void setCountdown(Long countdown) {
        this.countdown = countdown;
    }

    public String getShortLink() {
        return shortLink;
    }

    public void setShortLink(String shortLink) {
        this.shortLink = shortLink;
    }

    public List<LeaderboardDTO> getLeaderboardDTOS() {
        return leaderboardDTOS;
    }

    public void setLeaderboardDTOS(List<LeaderboardDTO> leaderboardDTOS) {
        this.leaderboardDTOS = leaderboardDTOS;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Long getParticipantCount() {
        return participantCount;
    }

    public void setParticipantCount(Long participantCount) {
        this.participantCount = participantCount;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getFacadeUrl() {
        return facadeUrl;
    }

    public void setFacadeUrl(String facadeUrl) {
        this.facadeUrl = facadeUrl;
    }

    public String getDisplayAddress() {
        return displayAddress;
    }

    public void setDisplayAddress(String displayAddress) {
        this.displayAddress = displayAddress;
    }

    public String getShareBgUrl() {
        return shareBgUrl;
    }

    public void setShareBgUrl(String shareBgUrl) {
        this.shareBgUrl = shareBgUrl;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getDistance() {
        return distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }
}
