package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(description = "排行榜用户信息对象，不同的排行榜要求的字段均不同")
public class RankUserCompositeDTO {

    @ApiModelProperty("FORUM:发帖排行榜的上榜用户信息")
    private ForumRankUserDTO forumRankUser;

    @ApiModelProperty("INVITE:收徒排行榜的上榜用户信息")
    private InviteRankUserDTO inviteRankUser;

    @ApiModelProperty("INTERACT:互动排行榜的上榜用户信息")
    private InteractRankUserDTO interactRankUser;

    public RankUserCompositeDTO(ForumRankUserDTO forumRankUser) {
        this.forumRankUser = forumRankUser;
    }

    public RankUserCompositeDTO(InviteRankUserDTO inviteRankUser) {
        this.inviteRankUser = inviteRankUser;
    }

    public RankUserCompositeDTO(InteractRankUserDTO interactRankUser) {
        this.interactRankUser = interactRankUser;
    }
}
