package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @ClassName RedPacketDTO
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/17 21:47
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/17 21:47
 **/
@ApiModel(description = "红包详情")
@Data
@NoArgsConstructor
public class RedPacketDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("红包所有人头像")
    private String ownerUserImg;
    @ApiModelProperty("红包所有人昵称")
    private String ownerUserName;
    @ApiModelProperty("红包总金额")
    private String amount;
    @ApiModelProperty("红包口令")
    private String content;
    @ApiModelProperty("宣传文案")
    private String promotionContent;
    @ApiModelProperty("宣传图片")
    private List<String> contentImg;
    @ApiModelProperty("红包状态，0:已下线|1:未领完且未领取|2:已领取|3:已领完且未领取")
    private Integer rpStatus;
    @ApiModelProperty("当前用户已领到金额")
    private String userObtainAmount;
    @ApiModelProperty("领取情况,0:没有一个人领取过红包|1:有部分被领取了|2:全部被领完")
    private Integer obtainStatus;
    @ApiModelProperty("当前红包被领取总金额")
    private String obtainAmount;
    @ApiModelProperty("红包类型：1红包墙 2微信红包")
    private Integer      type;

    public RedPacketDTO(Integer rpStatus){
        this.rpStatus = rpStatus;
    }
}
