package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Objects;

@ApiModel(description = "签到转发获得红花返回对象")
@Data
public class SignCompleTaskDTO extends NewsMissionRewardDto{

    @ApiModelProperty("红花奖品选择列表")
    private List<RewardChoose> rewardChooses;

    public List<RewardChoose> getRewardChooses() {
        return rewardChooses;
    }

    public void setRewardChooses(List<RewardChoose> rewardChooses) {
        this.rewardChooses = rewardChooses;
    }

    @ApiModel(description = "红花奖品")
    public static class RewardChoose{

        @ApiModelProperty("红花数量")
        private Integer goldNum;

        @ApiModelProperty("加倍数")
        private Float multiple;

        @ApiModelProperty("用户选中的奖品")
        private boolean selected;

        public RewardChoose(Integer goldNum, Float multiple, boolean selected) {
            this.goldNum = goldNum;
            this.multiple = multiple;
            this.selected = selected;
        }

        public RewardChoose() {
        }

        public Integer getGoldNum() {
            return goldNum;
        }

        public void setGoldNum(Integer goldNum) {
            this.goldNum = goldNum;
        }

        public Float getMultiple() {
            return multiple;
        }

        public void setMultiple(Float multiple) {
            this.multiple = multiple;
        }

        public boolean isSelected() {
            return selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            RewardChoose that = (RewardChoose) o;
            return selected == that.selected &&
                    Objects.equals(goldNum, that.goldNum) &&
                    Objects.equals(multiple, that.multiple);
        }

        @Override
        public int hashCode() {
            return Objects.hash(goldNum, multiple, selected);
        }
    }

}
