package com.bxm.localnews.activity.dto;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @ClassName WallRedPacketDTO
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/17 21:31
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/17 21:31
 **/
@ApiModel(description = "红包墙-红包详情")
@Data
public class WallRedPacketDTO implements Serializable{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("红包id")
    private Long id;
    @ApiModelProperty("头像")
    private String userImg;
    @ApiModelProperty("昵称")
    private String userName;
    @ApiModelProperty("红包总金额")
    private String amount;
    @ApiModelProperty("红包状态，0:已领完|1:已领取|2:可领取")
    private Integer status;
    @ApiModelProperty("红包口令")
    private String content;

}
