package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

/**
 * @author zhaoyadong 2018/12/24 11:24
 * @desc
 */
@ApiModel(description = "微信用户信息")
public class WechatUserInfoDTO {

    @ApiModelProperty("微信昵称")
    private String wechatName;

    @ApiModelProperty("微信头像")
    private String wechatImg;

    public String getWechatName() {
        return wechatName;
    }

    public void setWechatName(String wechatName) {
        this.wechatName = wechatName;
    }

    public String getWechatImg() {
        return wechatImg;
    }

    public void setWechatImg(String wechatImg) {
        this.wechatImg = wechatImg;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WechatUserInfoDTO that = (WechatUserInfoDTO) o;
        return Objects.equals(wechatName, that.wechatName) &&
                Objects.equals(wechatImg, that.wechatImg);
    }

    @Override
    public int hashCode() {
        return Objects.hash(wechatName, wechatImg);
    }
}
