package com.bxm.localnews.activity.dto.sign;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jdk.nashorn.internal.ir.annotations.Ignore;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author pf.w
 * @date 2020/10/22 15:28
 **/
@Data
@ApiModel(description = "签到基本信息")
public class DailySignDTO extends SignDTO{

    @ApiModelProperty("用户总金币数(红花数)")
    private BigDecimal totalGold;

    @ApiModelProperty("该地区是否有夺宝活动")
    private Boolean enableSnatchTreasures;

    @ApiModelProperty("活动跳链地址  有夺宝跳夺宝  无夺宝跳赚红包页")
    private String snatchTreasuresLinkUrl;

    @ApiModelProperty("夺宝活动文案  兑好礼 | 去夺宝")
    private String linkText;

    @ApiModelProperty("当前签到地区是否已开通签到排行榜")
    private Boolean enableSignBoard;

    @ApiModelProperty("签到排行榜路由地址")
    private String signBoardLinkUrl;

    @ApiModelProperty("用户排名  无排名为0")
    private Integer rank;

    @ApiModelProperty("累计签到天数")
    private Long count;

    @ApiModelProperty("0:第一天登录不显示补签图标  1：需要补签 2：不需要补签")
    private Integer yesterdaySignState;

    @ApiModelProperty("补签后可恢复的连续签到天数")
    private Long countContinue;

    @ApiModelProperty("是否开通签到提醒")
    private Boolean enableOpenSignWarning;

    @ApiModelProperty("连续签到天数可获得奖励(按钮文案显示天数)")
    @JsonIgnore
    private Integer signDayContinueForAward;

    @ApiModelProperty("签到按钮副标题文本")
    protected String signButtonSubtitle;

    @ApiModelProperty("签到可获得金币数(红花数)--日常签到红花数")
    private Integer goldNum;

    @ApiModelProperty("是否可领取  true : 可领")
    private Boolean enableReceive;
}
