package com.bxm.localnews.activity.dto.sign;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author pf.w
 * @date 2020/10/22 18:18
 **/
@Data
@ApiModel(description = "签到日历")
public class SignRecordListDTO {

    @ApiModelProperty("签到对应日期")
    private String signDate;

    @JsonIgnore
    @ApiModelProperty("签到对应日期")
    private Date dateSign;

    @ApiModelProperty("是否已签到，true表示已签到")
    private Boolean signFlag ;

    @ApiModelProperty("是否是今天")
    private Boolean isToday;

    @ApiModelProperty("是否补签")
    private Boolean fill;

    @ApiModelProperty("签到奖励金币数（红花数）")
    private Long goldNum;

    @ApiModelProperty("是否有签到红包")
    private Boolean enableGift;

}
