package com.bxm.localnews.activity.param;


import com.bxm.newidea.component.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Author: pf.w
 * @Date: 2020/5/4 15:35
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "特惠商家列表参数")
@Data
public class MerchantListParam extends BasicParam {
    @ApiModelProperty(value = "经度", required = false)
    private Double longitude;

    @ApiModelProperty(value = "维度", required = false)
    private Double latitude;

    @ApiModelProperty(value = "用户id", required = false)
    private Long userId;

    @ApiModelProperty(value = "地区编码", required = true)
    private String areaCode;

    @ApiModelProperty(value = "商家类型" ,required = false)
    private Integer type = 0;

    @ApiModelProperty(value = "排序类型 0-默认推荐  1-距离" ,required = true)
    private Integer sortType = 0;
}
