package com.bxm.localnews.activity.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 新增口令红包参数
 * </p>
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/17
 */
@ApiModel(description = "新增口令红包参数")
@Data
public class RedPacketAddParam {
    @ApiModelProperty(value = "用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "用户昵称", required = true)
    private String userName;

    @ApiModelProperty(value = "用户头像地址", required = true)
    private String userImg;

    @ApiModelProperty(value = "红包金额", required = true)
    private Double amount;

    @ApiModelProperty(value = "红包个数", required = true)
    private Integer experctNum;

    @ApiModelProperty(value = "红包类型：1红包墙 2微信红包", required = true)
    private Integer type;

    @ApiModelProperty(value = "口令id", required = false)
    private Long twisterId;

    @ApiModelProperty(value = "口令内容", required = true)
    private String content;

    @ApiModelProperty(value = "宣传内容", required = false)
    private String promotionContent;

    @ApiModelProperty(value = "宣传图片", required = false)
    private List<String> promotionImgs;

    @ApiModelProperty(value = "地区code", required = true)
    private String areaCode;

    @ApiModelProperty(value = "地区名称", required = true)
    private String areaName;

}
