package com.bxm.localnews.activity.vo;

import java.util.Date;

/**
 * @author zhaoyadong 2019/5/25 16:22
 * @desc
 */
public class BrowseRecord {
    /**
     * id
     */
    private Long id;

    /**
     * 分享人id
     */
    private Long userId;

    /**
     * 浏览人id
     */
    private Long browseUserId;

    /**
     * 浏览人openId
     */
    private String browseOpenId;

    /**
     * 浏览时间 年-月-日
     */
    private Date browseTime;

    /**
     * 浏览用户类型
     * 新用户：NEW_USER
     * 老用户：OLD_USER
     */
    private String browseUserType;

    /**
     * 是否有奖励
     * 0-无，1-有
     */
    private Byte award;

    /**
     * 奖励金额
     */
    private Integer awardGold;

    private Date createTime;

    private Date updateTime;

    public BrowseRecord() {
    }

    public BrowseRecord(Long id, Long userId, Long browseUserId, String browseOpenId, Date browseTime,
                        String browseUserType, Byte award, Integer awardGold) {
        this.id = id;
        this.userId = userId;
        this.browseUserId = browseUserId;
        this.browseOpenId = browseOpenId;
        this.browseTime = browseTime;
        this.browseUserType = browseUserType;
        this.award = award;
        this.awardGold = awardGold;
        Date now = new Date();
        this.createTime = now;
        this.updateTime = now;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getBrowseUserId() {
        return browseUserId;
    }

    public void setBrowseUserId(Long browseUserId) {
        this.browseUserId = browseUserId;
    }

    public String getBrowseOpenId() {
        return browseOpenId;
    }

    public void setBrowseOpenId(String browseOpenId) {
        this.browseOpenId = browseOpenId;
    }

    public Date getBrowseTime() {
        return browseTime;
    }

    public void setBrowseTime(Date browseTime) {
        this.browseTime = browseTime;
    }

    public String getBrowseUserType() {
        return browseUserType;
    }

    public void setBrowseUserType(String browseUserType) {
        this.browseUserType = browseUserType;
    }

    public Byte getAward() {
        return award;
    }

    public void setAward(Byte award) {
        this.award = award;
    }

    public Integer getAwardGold() {
        return awardGold;
    }

    public void setAwardGold(Integer awardGold) {
        this.awardGold = awardGold;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
