package com.bxm.localnews.activity.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 红包获取记录
 * </p>
 *
 * @author JandMin
 * @since 2019-04-18
 */
public class RedPacketObtainHistory implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 红包拥有人的用户名称
     */
    private String ownerUserName;
    /**
     * 红包ID
     */
    private Long rpId;
    /**
     * 领取用户ID
     */
    private Long userId;
    /**
     * 领取用户名称
     */
    private String userName;
    /**
     * 领取用户头像
     */
    private String userImg;
    /**
     * 路由文件路径
     */
    private String recordUrl;
    /**
     * 路由文件时长(单位：秒)
     */
    private Integer recordLength;
    /**
     * 获取金额
     */
    private BigDecimal obtainAmount;
    /**
     * 综合评分
     */
    private Integer score;
    /**
     * 参与时间
     */
    private Date createTime;

    public String getOwnerUserName() {
        return ownerUserName;
    }

    public void setOwnerUserName(String ownerUserName) {
        this.ownerUserName = ownerUserName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRpId() {
        return rpId;
    }

    public void setRpId(Long rpId) {
        this.rpId = rpId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserImg() {
        return userImg;
    }

    public void setUserImg(String userImg) {
        this.userImg = userImg;
    }

    public String getRecordUrl() {
        return recordUrl;
    }

    public void setRecordUrl(String recordUrl) {
        this.recordUrl = recordUrl;
    }

    public Integer getRecordLength() {
        return recordLength;
    }

    public void setRecordLength(Integer recordLength) {
        this.recordLength = recordLength;
    }

    public BigDecimal getObtainAmount() {
        return obtainAmount;
    }

    public void setObtainAmount(BigDecimal obtainAmount) {
        this.obtainAmount = obtainAmount;
    }

    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        return "RedPacketObtainHistory{" +
        "id=" + id +
        ", rpId=" + rpId +
        ", userId=" + userId +
        ", userName=" + userName +
        ", userImg=" + userImg +
        ", recordUrl=" + recordUrl +
        ", recordLength=" + recordLength +
        ", obtainAmount=" + obtainAmount +
        ", score=" + score +
        ", createTime=" + createTime +
        "}";
    }
}
