package com.bxm.localnews.activity.vo;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 红包分享话术相关配置
 * </p>
 *
 * @author JandMin
 * @since 2019-04-18
 */
public class RedPacketShare implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 分享话术
     */
    private String content;
    /**
     * 类型（1：未参与、2：已参与）
     */
    private Integer type;
    /**
     * 分享图片地址
     */
    private String imgUrl;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 是否删除（0：未删除、1：已删除）
     */
    private Integer deleteFlag;
    /**
     * 删除时间
     */
    private Date deleteTime;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(Integer deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Date getDeleteTime() {
        return deleteTime;
    }

    public void setDeleteTime(Date deleteTime) {
        this.deleteTime = deleteTime;
    }

    @Override
    public String toString() {
        return "RedPacketShare{" +
        "id=" + id +
        ", content=" + content +
        ", type=" + type +
        ", imgUrl=" + imgUrl +
        ", createTime=" + createTime +
        ", deleteFlag=" + deleteFlag +
        ", deleteTime=" + deleteTime +
        "}";
    }
}
