package com.bxm.localnews.activity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>
 *     口令红包前端展示实体类
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/17
 */
@ApiModel(description = "红包记录")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RedPacketTotalVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("总金额")
    private String                   totalAmount;
    @ApiModelProperty("总数量")
    private Integer                   totalNum;
}
