package com.bxm.localnews.activity.vo;

import java.util.Date;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnore;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "签到记录")
public class SignRecord extends BaseBean implements IUserIdSharding {

    @ApiModelProperty(hidden = true)
    @JsonIgnore
    private Long id;

    @ApiModelProperty(hidden = true)
    @JsonIgnore
    private Long userId;

    @ApiModelProperty(value = "签到日期")
    private Date signDate;

    @ApiModelProperty("签到天数")
    private Integer signDay = 0;

    @ApiModelProperty("签到奖励")
    private Long signReward = 0L;

    @ApiModelProperty("是否已签到，true表示已签到")
    private Boolean signFlag = Boolean.FALSE;

    @ApiModelProperty("是否补签，true表示补签")
    private Boolean fillSign = Boolean.FALSE;

    @ApiModelProperty("区域编码")
    private String areaCode;

    public SignRecord() {
    }

    public SignRecord(Long userId, Date signDate, long signReward) {
        this.userId = userId;
        this.signDate = signDate;
        this.signReward = signReward;
    }

    public SignRecord(Long id, Long userId, Date signDate, Integer signDay, Long signReward, Boolean fillSign,String areaCode) {
        this.id = id;
        this.userId = userId;
        this.signDate = signDate;
        this.signDay = signDay;
        this.signReward = signReward;
        this.fillSign = fillSign;
        this.areaCode = areaCode;
    }

    public Boolean getSignFlag() {
        return signFlag;
    }

    public void setSignFlag(Boolean signFlag) {
        this.signFlag = signFlag;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Date getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Integer getSignDay() {
        return this.signDay;
    }

    public void setSignDay(Integer signDay) {
        this.signDay = signDay;
    }

    public Long getSignReward() {
        return this.signReward;
    }

    public void setSignReward(Long signReward) {
        this.signReward = signReward;
    }

    public String getRewardStr() {
        return "+" + this.signReward;
    }

    public Boolean getFillSign() {
        return fillSign;
    }

    public void setFillSign(Boolean fillSign) {
        this.fillSign = fillSign;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public SignRecord setAreaCode(String areaCode) {
        this.areaCode = areaCode;
        return this;
    }
}