package com.bxm.localnews.activity.command;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.vo.BaseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * 任务完成后发送消息给用户
 * @author shentao
 */
public class TransferPushMsgCommand extends BaseBean implements TaskCommand {

    private static final Logger logger = LoggerFactory.getLogger(TransferPushMsgCommand.class);

    private static final long serialVersionUID = -8834649902300563530L;

    private TaskContext context;

    private UserAccountIntegrationService userAccountIntegrationService;

    private PushMsgSupplyFeignService pushMsgSupplyFeignService;

    public TransferPushMsgCommand(TaskContext context,
                                  UserAccountIntegrationService userAccountIntegrationService,
                                  PushMsgSupplyFeignService pushMsgSupplyFeignService) {
        this.context = context;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.pushMsgSupplyFeignService = pushMsgSupplyFeignService;
    }

    @Override
    public void execute() {
        Long userId = context.getUserId();
        DailyTask dailyTask = context.getDailyTask();

        String title = "任务完成";

        Integer goldBalance = userAccountIntegrationService.getUserUsableGold(userId);

        String content = "恭喜你成功完成了【" + dailyTask.getName() + "】,获得" + dailyTask.getReward().longValue() + "朵花,"
                + "目前共有" + goldBalance + "朵花";



        PushMessage pushMessage = PushMessage.build()
                .setTitle(title)
                .setContent(content)
                .setPersistence(context.getPersistenceMsg())
                .setPushReceiveScope(PushReceiveScope.pushSignle(userId))
                .setPayloadInfo(PushPayloadInfo.build(TaskEnum.getPushMessageEnumByDesc(dailyTask.getName()))
                        .addExtend("activityName", dailyTask.getName())
                        .addExtend("activityReward", dailyTask.getReward().longValue() + "")
                        .addExtend("totalGold", goldBalance + ""));
        logger.info("【任务完成后】推送完成任务消息[{}]", JSONObject.toJSONString(pushMessage));
        //如果启用推送，则推送、添加用户消息中心一并处理
        if (context.getPushMsg()) {
            pushMsgSupplyFeignService.pushMsg(pushMessage);
        } else if (context.getPersistenceMsg()) {
            //如果仅添加到消息中心
            pushMsgSupplyFeignService.addMsg(pushMessage, userId);
        }
    }
}
