package com.bxm.localnews.activity.command;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.newidea.component.vo.BaseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 任务完成后给用户发送自定义事件
 */
public class TransferUserEventCommand extends BaseBean implements TaskCommand {

    private static final Logger logger = LoggerFactory.getLogger(TransferPushMsgCommand.class);

    private static final long serialVersionUID = -8834649902300563531L;

    private TaskContext context;

    private PushMsgSupplyFeignService pushMsgSupplyFeignService;

    private UserAccountIntegrationService userAccountIntegrationService;

    public TransferUserEventCommand(TaskContext context,
                                    UserAccountIntegrationService userAccountIntegrationService,
                                    PushMsgSupplyFeignService pushMsgSupplyFeignService) {
        this.context = context;
        this.pushMsgSupplyFeignService = pushMsgSupplyFeignService;
        this.userAccountIntegrationService = userAccountIntegrationService;
    }

    @Override
    public void execute() {
        Long userId = context.getUserId();
        DailyTask dailyTask = context.getDailyTask();

        Integer goldBalance = userAccountIntegrationService.getUserUsableGold(userId);

        PushPayloadInfo pushPayloadInfo = PushPayloadInfo.build(PushMessageEnum.TASK_COMPLETE_EVENT)
                .addExtend("userId", userId)
                .addExtend("activityName", dailyTask.getName())
                .addExtend("activityReward", dailyTask.getReward().longValue())
                .addExtend("totalGold", goldBalance + dailyTask.getReward().longValue());
        logger.info("【任务完成后】发送用户自定义事件:[{}]", JSONObject.toJSONString(pushPayloadInfo));
        pushMsgSupplyFeignService.addUserEvent(pushPayloadInfo);
    }
}
