package com.bxm.localnews.activity.record.convert.impl;

import com.bxm.localnews.activity.record.convert.IConverter;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

import java.io.File;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

@Component
@Slf4j
public class Speex2WavConverter implements IConverter {


    private final static Logger logger = LoggerFactory.getLogger(Speex2WavConverter.class);

    private final BizConfigProperties bizConfigProperties;

    private final SequenceCreater sequenceCreater;

    private final AsyncTaskExecutor taskExecutor;

    @Autowired
    public Speex2WavConverter(BizConfigProperties bizConfigProperties,
                              SequenceCreater sequenceCreater,
                              AsyncTaskExecutor taskExecutor) {
        this.bizConfigProperties = bizConfigProperties;
        this.sequenceCreater = sequenceCreater;
        this.taskExecutor = taskExecutor;
    }

    @Override

    public String support() {
        return "speex";
    }

    @Override
    public String after() {
        return "wav";
    }

    @Override
    public File convert(File sourceFile) {
        byte[] body = null;
        String wavFilePath = bizConfigProperties.getTempDir() + sequenceCreater.nextStringId() + ".wav";
        File converFile = null;

        logger.info("source file length:[{}]",sourceFile.length());
        try {
            //[liujia]需要在对应的服务器安装解析程序
            String command = MessageFormat.format("speex_decode {0} {1}", sourceFile.getPath(), wavFilePath);
            int n = execCommand(command);
            // 获取文件流
            if (n == 0) {
                converFile = new File(wavFilePath);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

        return converFile;
    }

    private int execCommand(String command) {
        Process process = null;
        Future<Integer> executeFuture = null;
        try {
            process = Runtime.getRuntime().exec(command);

            final Process p = process;
            Callable<Integer> call = () -> {
                p.waitFor();
                return p.exitValue();
            };

            //使用线程池防止Process阻塞
            executeFuture = taskExecutor.submit(call);
            return executeFuture.get(5000, TimeUnit.MILLISECONDS);

        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return 1;
        } finally {
            if (executeFuture != null) {
                try {
                    executeFuture.cancel(true);
                } catch (Exception ignore) {
                }
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

}
