package com.bxm.localnews.activity.record.grade.impl;

import com.bxm.localnews.activity.vo.RecordGradeContext;
import org.springframework.stereotype.Component;

/**
 * 中文汉字匹配策略
 *
 * 原始字符串到目标字符串的字符串编辑距离
 * @author liujia
 */
@Component
public class ChineseCharacterStrategy extends AbstractGradStrategy {

    @Override
    public void grade(RecordGradeContext context) {
        String target = context.getConverTarget();
        int distance = minDistance(target, context.getResult());
        int length = target.length();
        float score = 0F;

        //如果编辑距离小于总长度
        if (distance < length) {
            score = (float) (length - distance) / length * 100;
        }

        context.getGrade().setMatchScore(score);
    }
}
