package com.bxm.localnews.activity.record.grade.impl;

import com.bxm.localnews.activity.vo.RecordGradeContext;
import org.springframework.stereotype.Component;

/**
 * 语速评分策略
 * 根据原始字符串计算预计读取速度，根据录音长度进行匹配
 * @author liujia
 */
@Component
public class SpeedStrategy extends AbstractGradStrategy {
    /**
     * 语速基础值
     */
    private int baseRate = 250;

    @Override
    public void grade(RecordGradeContext context) {
        int sourceLength = context.getConverTarget().length();
        int duration = context.getDuration() * 1000;

        float speed = (float) duration / sourceLength + baseRate;
        float score;

        if (speed > 3000) {
            score = 0F;
        } else if (speed > 1000) {
            score = (float) (60 - (speed - 1000) * 0.03);
        } else if (speed > 600) {
            score = (float) (80 - (speed - 600) * 0.05);
        } else if (speed > 350) {
            score = (float) (100 - (speed - 350) * 0.08);
        } else {
            score = 100F;
        }

        context.getGrade().setSpeedScore(score);
    }
}
