package com.bxm.localnews.activity.service;

import java.util.List;

import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.activity.vo.TaskDTO;
import com.bxm.localnews.activity.vo.UserMissionModel;

import org.apache.ibatis.annotations.Param;

/**
 * 日常任务服务接口
 *
 * @author liujia 2018/7/31 11:05
 */
public interface DailyTaskService {

    int deleteByPrimaryKey(Long id);

    int insert(DailyTask record);

    int insertSelective(DailyTask record);

    DailyTask selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(DailyTask record);

    int updateByPrimaryKey(DailyTask record);

    /**
     * 根据平台类型查看日常任务
     *
     * @param userId
     * @param appletType
     * @return
     */
    List<UserMissionModel> listMissions(Long userId, String appletType);

    int countNewbieTask();

    /**
     * 根据任务Id和userId 查询新手任务
     *
     * @param taskType
     * @return
     */
    List<DailyTask> findSelectiveByType(@Param("taskType") Byte taskType);

    List<DailyTask> getTaskByParams(TaskDTO taskDTO);

    int getTaskCount(TaskDTO taskDTO);

    int updateTaskStateByIds(@Param("ids") String[] ids, @Param("state") Byte state);

}
