package com.bxm.localnews.activity.service;

import java.math.BigDecimal;
import java.util.List;

import com.bxm.localnews.activity.param.CashDetailParam;
import com.bxm.localnews.activity.vo.WechatUserInfoVo;
import com.bxm.newidea.component.vo.PageWarper;

public interface LotteryDrawService {

    /**
     * 获取抽奖用户信息
     *
     * @param userId
     * @param city
     * @param district
     * @return
     */
    WechatUserInfoVo getUserInfo(Long userId, String city, String district);

    /**
     * 获取奖项
     *
     * @return
     */
    List<BigDecimal> getPrizeList();

    /**
     * 获取中奖用户列表
     *
     * @return
     */
    List<WechatUserInfoVo> getWinUserList();

    /**
     * 抽奖
     *
     * @param userId
     * @return
     */
    String lotteryDraw(Long userId, Integer platform, String areaCode);

    /**
     * 分享
     *
     * @param userId
     * @return
     */
    Boolean share(Long userId);

    /**
     * 获取明细
     *
     * @param param
     * @return
     */
    PageWarper<WechatUserInfoVo> getDetailPage(CashDetailParam param);

    /**
     * 是否活动区域
     *
     * @param city
     * @param district
     * @return
     */
    Boolean isActiveArea(String city, String district);
}
