package com.bxm.localnews.activity.service;

import com.bxm.localnews.activity.dto.MovieDTO;
import com.bxm.localnews.activity.dto.NoticeDTO;
import com.bxm.localnews.activity.param.MovieParam;

public interface MovieService {

    /**
     * 用途：根据用户id查找是否该用户有电影票
     * @param userId
     * @return
     */
    boolean isHasMovie(Long userId);

    /**
     * 用途：根据用户id查找用户所拥有的电影票的详情信息
     * @param movieParam
     * @return
     */
    MovieDTO getMovieDetail(MovieParam movieParam);

    /**
     * 用途：为每个VIP用户分发一张电影票
     * @param userId
     */
    void doGeneratorMovie(Long userId,String areaCode);

    /**
     * 用途：得到右上角VIP入口的小红点
     * @param userId
     * @return
     */
    NoticeDTO getMovieVipNotice(Long userId);

    /**
     * 用途：更新右上角VIP入口的小红点为已看过
     * @param userId
     */
    void updateMovieVipNotice(Long userId);

}
