package com.bxm.localnews.activity.service;

import com.bxm.localnews.activity.dto.*;
import com.bxm.localnews.activity.param.*;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.newidea.component.geo.dto.Coordinate;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * Created by Arei on 2018/10/18.
 */
public interface PrivilegeService {
    /**
     * 获取被邀请人列表
     * @param privilegeParticipantParam
     * @return
     */
    PageWarper<PrivilegeParticipantDTO> listPrivilegeParticipantByInvite(PrivilegeParticipantParam privilegeParticipantParam);

    /**
     * 获取活动列表
     * @param privilegeParam
     * @return
     */
    PageWarper<PrivilegeListDTO> listPrivilege(PrivilegeParam privilegeParam, BasicParam basicParam);

    /**
     * 用途：获取活动列表[all]
     * 场景：用户在分享活动给微信好友时,当好友点开链接,根据排序显示活动列表
     * 1.如果用户提供真实坐标，则计算实际距离
     * 2.如果没有真实坐标则获取用户在服务端保存的地理位置
     * 3.如果无法获得真实坐标与服务端坐标则按默认权重排序
     * @param privilegeParam
     * @return
     */
    List<PrivilegeOverviewDTO> listAllPrivilege(PrivilegeOverviewParam privilegeParam);

    /**
     * 获取推荐活动列表
     * @param privilegeRecommendParam
     * @return
     */
    PageWarper<PrivilegeListDTO> listRecommendPrivilege(PrivilegeRecommendParam privilegeRecommendParam);

    /**
     * 获取活动详情
     * @param privilegeDetailParam 活动详情参数
     * @return
     */
    PrivilegeDTO getPrivilegeDetail(PrivilegeDetailParam privilegeDetailParam);

    /**
     * 获取活动的中奖人名单
     * @param privilegeId
     * @param userId
     * @param isDisplayCommodityCode 是否返回中奖码，H5中不显示
     * @return
     */
    List<WinnerDTO> listWinnerByPrivilegeId(Long privilegeId, Long userId, boolean isDisplayCommodityCode);

    /**
     * 获取活动详情
     * @param id           活动id
     * @param userId       登录用户id
     * @param inviteUserId 邀请人用户id，目前只会在H5中出现，用来标记是否助力过当前邀请人
     * @return
     */
    PrivilegeDTO getPrivilegeDetail(Long id, Long userId, Long inviteUserId);

    /**
     * 获取经纬度
     * @param privilegeParam
     * @return
     */
    Coordinate getUserCoordinate(PrivilegeParam privilegeParam);
}
