package com.bxm.localnews.activity.service;

import java.util.List;

import com.bxm.localnews.activity.dto.*;
import com.bxm.localnews.activity.param.RecordWechatParam;
import com.bxm.localnews.activity.vo.Vip;
import com.bxm.newidea.component.vo.Message;

/**
 * @author zhaoyadong 2018/12/24 18:01
 * @desc
 */
public interface VipService {

    /**
     * 用户通过分享页面领取vip
     *
     * @param areaCode   地区编码
     * @param wechatUid  微信id
     * @param wechatName 微信昵称
     * @param wechatImg  微信头像
     */
    WechatVipInfoDTO addWechatUserVip(String areaCode, String wechatUid, String wechatName, String wechatImg);

    /**
     * 获取用户激活vip成功邀请的微信用户信息
     *
     * @param userId
     * @return
     */
    UserSuccessFriendDTO getSuccessFriend(Long userId);

    /**
     * 获取用户查看用户vip页面的记录列表
     *
     * @param userId
     * @return
     */
    List<WechatUserInfoDTO> getInviteFriendRecord(Long userId);

    /**
     * 添加用户访问vip页面的记录
     *
     * @param recordWechatParam
     */
    Message addViewRecord(RecordWechatParam recordWechatParam);

    /**
     * 获取客服信息
     *
     * @return
     */
    CustomerServiceDTO getCustomerService();

    /**
     * 更新用户领取vip的引导信息
     *
     * @param userId
     */
    Message modifyUserGuid(Long userId);

    /**
     * 根据用户id获取VIP信息
     *
     * @param userId
     * @return
     */
    UserVipInfoDTO modifyAndGetUserVip(Long userId, String areaCode);

    /**
     * 检查用户是否激活VIP
     *
     * @param userId
     * @return
     */
    boolean checkUserVip(Long userId);

    /**
     * 根据unionId获取VIP信息
     *
     * @param unionId
     * @param areaCode
     * @return
     */
    WechatVipInfoDTO getWechatVip(String unionId, String areaCode);

    /**
     * 获取vip已激活的轮播信息
     *
     * @return
     */
    List<WechatUserInfoDTO> getVipRank();

    /**
     * 更新用户不再提示显示浮层
     *
     * @param userId
     * @return
     */
    Message modifyUserShowLayer(Long userId);

    /**
     * 根据用户id取得vip信息
     *
     * @param userId
     * @return
     */
    Vip getVipByUser(Long userId);

    /**
     * 获取用户邀请成功的所有列表
     *
     * @param userId
     * @return
     */
    List<WechatUserInfoDTO> getAllSuccessWechatUserList(Long userId);
}
