package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.domain.LevelConfigMapper;
import com.bxm.localnews.activity.service.LevelConfigService;
import com.bxm.localnews.activity.vo.LevelConfig;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

import static com.bxm.localnews.common.constant.RedisConfig.USER_LEVEL_CONFIG;

@Service
public class LevelConfigServiceImpl implements LevelConfigService {

    private LevelConfigMapper levelConfigMapper;

    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public LevelConfigServiceImpl(LevelConfigMapper levelConfigMapper, RedisStringAdapter redisStringAdapter) {
        this.levelConfigMapper = levelConfigMapper;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public List<LevelConfig> getLevelConfigs() {
        TypeReference<List<LevelConfig>> typeReference = new TypeReference<List<LevelConfig>>() {
        };
        List<LevelConfig> result = this.redisStringAdapter.get(USER_LEVEL_CONFIG, typeReference);

        if (CollectionUtils.isEmpty(result)) {
            result = this.levelConfigMapper.listAll();
            this.redisStringAdapter.set(USER_LEVEL_CONFIG, result, 3600 * 24 * 7);
        }
        return result;
    }

    @Override
    public LevelConfig selectByPrimaryKey(Long id) {
        List<LevelConfig> levelConfigs = getLevelConfigs();

        for (LevelConfig config : levelConfigs) {
            if (null != id && id.equals(config.getId())) {
                return config;
            }
        }

        return null;
    }

}
