package com.bxm.localnews.activity.service.redpacket.command;

import com.bxm.localnews.activity.dto.*;
import com.bxm.localnews.activity.param.ObtainHistoryParam;
import com.bxm.localnews.activity.param.RedPacketAddParam;
import com.bxm.localnews.activity.param.RedPacketUpdateParam;
import com.bxm.localnews.activity.param.WallRedPacketParam;
import com.bxm.localnews.activity.vo.RedPacket;
import com.bxm.localnews.activity.vo.RedPacketTotalVo;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 红包服务
 *
 * @ClassName RedPacketService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/18 14:12
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/18 14:12
 **/
public interface RedPacketService {
    /**
     * 根据红包id获取一个红包对象
     *
     * @param rpId 红包id
     * @return 红包实体
     */
    RedPacket selectOne(Long rpId);

    /**
     * 获取红包墙的红包列表
     * @param wallRedPacketParam 红包墙传参
     * @return 红包墙分页实体
     */
    PageWarper<WallRedPacketDTO> getReadPacketWall(WallRedPacketParam wallRedPacketParam);

    /**
     * 获取红包墙中单个红包与用户的关系
     */
    WallRedPacketDTO getSingleWallReadPacket(Long userId,Long rpId);

    /**
     * 获取该红包对当前用户的展示的详情信息
     * @param userId 用户id
     * @param rpId 红包id
     * @return 红包详情实体
     */
    RedPacketDTO getReadPacketDetail(Long userId, Long rpId);


    /**
     * 获取该红包对当前用户的展示的详情信息（站外）
     * @param userId 当前用户id
     * @param shareUserId 分享用户id
     * @param rpId 红包id
     * @return 站外红包详情实体
     */
    RedPacketPublicDTO getPublicReadPacketDetail(Long userId,Long shareUserId, Long rpId);

    /**
     * 根据用户id获取用户发过的红包和抢过的红包总金额
     * @Date : 2019/4/18
     * @Author
     * @param owner
     * @param userId
     * @return com.bxm.localnews.activity.vo.RedPacketTotalVo
     * @throws
     */
    RedPacketTotalVo getTotalRecordByUser(Integer owner, Long userId);

    /**
     * 获取用户发送红包记录列表
     * @date: 2019/4/18
     * @param userId 用户id
     * @param current 当前页
     * @param pageSize 每页大小
     * @return java.lang.Object
     * @throws
     */
    PageWarper<RedPacketSentDTO> listSentRecord(Long userId, Integer current, Integer pageSize);

    /**
     * 获取用户获取红包的记录列表
     * @date: 2019/4/18
     * @param userId 用户id
     * @param current 当前页
     * @param pageSize 每页大小
     * @return java.lang.Object
     * @throws
     */
    PageWarper<RedPacketGottenDTO> listGottenRecord(Long userId, Integer current, Integer pageSize);
    /**
     * 获取该红包的领取记录 结果按创建时间排序
     * @param obtainHistoryParam
     * @return
     */
    PageWarper<PacketHistoryDTO> getObtainHistory(ObtainHistoryParam obtainHistoryParam);

    /**
     * 获取该红包的口令评分排名
     * 结果按评分、创建时间 降序
     * @param rpId 红包id
     * @return
     */
    List<PacketHistoryDTO> getRanking(Long rpId);

    /**
     * 红包口令审核
     * @param markScoreDTO
     * @param platform
     * @return
     */
    CommandResultDTO markScore(MarkScoreDTO markScoreDTO,Integer platform);

    /**
     * 红包口令审核（站外）
     * @param markScorePublicDTO
     * @param platform
     * @return
     */
    CommandResultDTO markScore(MarkScorePublicDTO markScorePublicDTO,Integer platform);

    /**
     * 修改红包信息
     * @date: 2019/4/18
     * @param redPacketUpdateParam
     * @return java.lang.Boolean
     * @throws 
     */
    Boolean updateRedPacket(RedPacketUpdateParam redPacketUpdateParam,Integer platform);

    /**
     * 新增红包
     * @date: 2019/4/18
     * @param redPacketAddParam
     * @return java.lang.Boolean
     * @throws 
     */
    Long insertRedPacket(RedPacketAddParam redPacketAddParam);

    /**
     * 获取分享信息
     * @date: 2019/4/18
     * @param rpId 红包id
     * @param userId 用户id
     * @param type 分享语类型
     * @param nickname 分享人昵称
     * @return com.bxm.localnews.activity.dto.RedPacketShareDTO
     * @throws 
     */
    RedPacketShareDTO getShareInfo(Long rpId, Long userId,Integer type, String nickname);

    /**
     * 获取所有配置选项
     * @date: 2019/4/18
     * @param userId
     * @return com.bxm.localnews.activity.dto.RedPacketItemDTO
     * @throws 
     */
    List<RedPacketItemDTO> listRedPacketItem(Long userId);

    /**
     * 获取红包口令模板
     * @date: 2019/4/18
     * @param userId
     * @return com.bxm.localnews.activity.dto.RedPacketContentDTO
     * @throws 
     */
    List<RedPacketContentDTO> listRedPacketContent(Long userId);

    /**
     * 获取单个红包修改信息
     * @date: 2019/4/18
     * @param rpId
     * @param userId
     * @return com.bxm.localnews.activity.dto.RedPacketUpdateDTO
     * @throws 
     */
    RedPacketUpdateDTO getRedPacketById(Long rpId, Long userId);

    /**
     * 订单支付情况查询
     * @param rpId 红包id
     * @param userId 用户id
     * @param paymentNum 支付订单号
     * @param platform 平台
     * @return
     */
    Byte queryOrder(Long rpId, Long userId, String paymentNum,Integer platform);

    /**
     * 获取是否活动区域
     * @param rpId
     * @param city
     * @param district
     * @return
     */
    Boolean isActiveArea(Long rpId,String city,String district);


    /**
     * 查询红包是否已经支付
     * @param rpId 红包id
     * @return 是否已经支付
     */
    Boolean isPaySuccess(Long rpId);
}
