package com.bxm.localnews.activity.strategy.dailyConcreteStrategy;

import com.bxm.localnews.activity.domain.BrowseRecordMapper;
import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Service;

/**
 * 日常任务-首次发帖
 * @author shentao
 */
@Service
public class PostIntivationTaskStrategy extends AbstractDailyTaskStrategy {

    public PostIntivationTaskStrategy(RedisStringAdapter redisStringAdapter,
                                      RedisHashMapAdapter redisHashMapAdapter,
                                      NewsProperties newsProperties,
                                      UserIntegrationService userIntegrationService,
                                      BrowseRecordMapper browseRecordMapper) {
        super(redisStringAdapter, redisHashMapAdapter, newsProperties, userIntegrationService, browseRecordMapper);
    }

    @Override
    protected Message customJudge(TaskContext taskContext) {
        return judgeIsOverRewardCount(taskContext);
    }

    @Override
    public boolean support(TaskEnum taskEnum) {
        return taskEnum.equals(TaskEnum.TASK_POST_INTIVATION);
    }

    @Override
    protected boolean isSupportPushMessage() {
        //2.5.0 不再发推送
        return false;
    }

    @Override
    protected long getTaskReward(TaskContext taskContext) {
        return taskContext.getDailyTask().getReward().intValue();
    }

    @Override
    protected NewsMissionRewardDto processing(TaskContext taskContext) {
        //2.5.0 不写入消息中心
        taskContext.setPersistenceMsg(false);
        return defaultProcess(taskContext);
    }
}
