package com.bxm.localnews.activity.strategy.newbieConcreteStrategy;

import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.common.constant.TaskEnum;
import org.springframework.stereotype.Service;

/**
 * 新手任务-完成个人资料设置
 */
@Service
public class InfoImproveTaskStrategy extends AbstractNewbieTaskStrategy {

    @Override
    public boolean support(TaskEnum taskEnum) {
        return taskEnum.equals(TaskEnum.TASK_IMPROVE_INFO);
    }

    @Override
    protected NewsMissionRewardDto processing(TaskContext taskContext) {
        // 2.5.0 完成个人资料任务后不发送推送，也不现实在用户通知中,但是要发用户事件
        taskContext.setPushMsg(false);
        taskContext.setPersistenceMsg(false);
        taskContext.setUserEvent(true);

        return defaultProcess(taskContext);
    }
}
